% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-stretch.R
\name{stretch}
\alias{stretch}
\alias{stretch_dfr}
\alias{stretch_dfc}
\title{Stretching window calculation}
\usage{
stretch(.x, .f, ..., .step = 1, .init = 1, .fill = NA, .bind = FALSE)

stretch_dfr(
  .x,
  .f,
  ...,
  .step = 1,
  .init = 1,
  .fill = NA,
  .bind = FALSE,
  .id = NULL
)

stretch_dfc(.x, .f, ..., .step = 1, .init = 1, .fill = NA, .bind = FALSE)
}
\arguments{
\item{.x}{An object to slide over.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.step}{A positive integer for incremental step.}

\item{.init}{A positive integer for an initial window size.}

\item{.fill}{A value to fill at the left/center/right of the data range depending
on \code{.align} (\code{NA} by default).  \code{NULL} means no filling.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{Either a string or \code{NULL}. If a string, the output will contain
a variable with that name, storing either the name (if \code{.x} is named) or
the index (if \code{.x} is unnamed) of the input. If \code{NULL}, the default, no
variable will be created.

Only applies to \verb{_dfr} variant.}
}
\value{
if \code{.fill != NULL}, it always returns the same length as input.
}
\description{
\lifecycle{deprecated}

Please consider using the \href{https://davisvaughan.github.io/slider}{slider} package.

Fixing an initial window and expanding more observations:
\itemize{
\item \code{stretch()} always returns a list.
\item \code{stretch_lgl()}, \code{stretch_int()}, \code{stretch_dbl()}, \code{stretch_chr()} use the same
arguments as \code{stretch()}, but return vectors of the corresponding type.
\item \code{stretch_dfr()} \code{stretch_dfc()} return data frames using row-binding & column-binding.
}
}
\examples{
x <- 1:5
stretch_dbl(x, mean, .step = 2)
stretch_lgl(x, ~ mean(.) > 2, .step = 2)
lst <- list(x = x, y = 6:10, z = 11:15)
stretch(lst, ~., .step = 2, .fill = NULL)
}
\seealso{
Other stretching window functions: 
\code{\link{stretch2}()}
}
\concept{stretching window functions}
\keyword{internal}
\alias{stretch_lgl}
\alias{stretch_chr}
\alias{stretch_dbl}
\alias{stretch_int}
