% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr-verbs.R
\name{gather.tbl_ts}
\alias{gather.tbl_ts}
\title{Gather columns into key-value pairs.}
\usage{
\method{gather}{tbl_ts}(data, key = "key", value = "value", ...,
  na.rm = FALSE, convert = FALSE, factor_key = FALSE)
}
\arguments{
\item{data}{A \code{tbl_ts}.}

\item{key}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:quo_name]{rlang::quo_name()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{value}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:quo_name]{rlang::quo_name()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{A selection of columns. If empty, all variables are
selected. You can supply bare variable names, select all
variables between x and z with \code{x:z}, exclude y with \code{-y}. For
more options, see the \code{\link[dplyr:select]{dplyr::select()}} documentation. See also
the section on selection rules below.}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column in \code{NA}.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link[=type.convert]{type.convert()}} on the key column. This is useful if the column
names are actually numeric, integer, or logical.}

\item{factor_key}{If \code{FALSE}, the default, the key values will be
stored as a character vector. If \code{TRUE}, will be stored as a factor,
which preserves the original ordering of the columns.}
}
\description{
Gather columns into key-value pairs.
}
\examples{
# example from tidyr
stocks <- tsibble(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)
stocks \%>\% gather(stock, price, -time)
}
\seealso{
\link[tidyr:gather]{tidyr::gather}
}
