% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.test.B.R
\name{TAR.test.B}
\alias{TAR.test.B}
\title{AR versus TAR bootstrap supLM test for nonlinearity}
\usage{
TAR.test.B(
  x,
  B = 1000,
  pa = 0.25,
  pb = 0.75,
  ar.ord,
  d = 1,
  btype = c("iid", "wb.h", "wb.r", "wb.n"),
  ...
)
}
\arguments{
\item{x}{A univariate time series.}

\item{B}{Integer. Number of bootstrap resamples. Defaults to 1000.}

\item{pa}{Real number in \code{[0,1]}. Sets the lower limit for the threshold search to the \code{100*pa}-th sample percentile.
The default is \code{0.25}}

\item{pb}{Real number in \code{[0,1]}. Sets the upper limit for the threshold search to the \code{100*pb}-th sample percentile.
The default is \code{0.75}}

\item{ar.ord}{Order of the AR part.}

\item{d}{Delay parameter. Defaults to \code{1}.}

\item{btype}{Bootstrap type, can be one of \code{'iid','wb.h','wb.r','wb.n'}, see Details.}

\item{\dots}{Additional arguments to be passed to \code{arima}.}
}
\value{
A list of class \code{htest} with components:
\describe{
\item{\code{statistic}}{The value of the supLM statistic.}
\item{\code{parameter}}{A named vector: \code{threshold} is the value that maximises the Lagrange Multiplier values.}
\item{\code{test.v}}{Vector of values of the LM statistic for each threshold given in \code{thd.range}.}
\item{\code{thd.range}}{Range of values of the threshold.}
\item{\code{fit}}{The null model: AR fit over \code{x}.}
\item{\code{sigma2}}{Estimated innovation variance from the AR fit.}
\item{\code{data.name}}{A character string giving the name of the data.}
\item{\code{prop}}{Proportion of values of the series that fall in the lower regime.}
\item{\code{p.value}}{The bootstrap p-value of the test.}
\item{\code{method}}{A character string indicating the type of test performed.}
\item{\code{Tb}}{The bootstrap null distribution.}
}
}
\description{
Implements various bootstrap supremum Lagrange Multiplier tests for a AR specification versus
a TAR specification.
}
\details{
Implements the bootstrap version of \code{\link{TAR.test}} the supremum Lagrange Multiplier test to test an AR specification versus a TARMA specification.
The option \code{btype} specifies the type of bootstrap as follows:
\describe{
\item{\code{iid}}{Residual iid bootstrap. See \insertCite{Gia22}{tseriesTARMA}, \insertCite{Gia23}{tseriesTARMA}.}
\item{\code{wb.h}}{Stochastic permutation of \insertCite{Han96}{tseriesTARMA}.}
\item{\code{wb.r}}{Residual wild bootstrap with Rademacher auxiliary distribution. See \insertCite{Gia22}{tseriesTARMA}, \insertCite{Gia23}{tseriesTARMA}.}
\item{\code{wb.n}}{Residual wild bootstrap with Normal auxiliary distribution. See \insertCite{Gia22}{tseriesTARMA}, \insertCite{Gia23}{tseriesTARMA}.}
}
}
\examples{
## a TAR(1,1) where the threshold effect is on the AR parameters
set.seed(123)
x1 <- TARMA.sim(n=100, phi1=c(0.5,-0.5), phi2=c(0.0,0.8), theta1=0, theta2=0, d=1, thd=0.2)
TAR.test.B(x1, ar.ord=1, d=1)
TAR.test.B(x1, ar.ord=1, d=1, btype='wb.r')
TAR.test.B(x1, ar.ord=1, d=1, btype='wb.h')

## a AR(1)
x2 <- arima.sim(n=100, model=list(order = c(1,0,0),ar=0.5))
TAR.test.B(x2, ar.ord=1, d=1)
TAR.test.B(x2, ar.ord=1, d=1, btype='wb.r')
TAR.test.B(x2, ar.ord=1, d=1, btype='wb.h')

}
\references{
\itemize{
\item \insertRef{Gia22}{tseriesTARMA}
\item \insertRef{Gia23}{tseriesTARMA}
\item \insertRef{Gor23}{tseriesTARMA}
\item \insertRef{Gia21}{tseriesTARMA}
\item \insertRef{Han96}{tseriesTARMA}
}
}
\seealso{
\code{\link{TAR.test}} for the heteroskedastic robust asymptotic test.  \code{\link{TARMAGARCH.test}} for the
robust version of the test with respect to GARCH innovations. \code{\link{TARMA.sim}} to simulate from a TARMA process.
}
\author{
Simone Giannerini, \email{simone.giannerini@unibo.it}

Greta Goracci, \email{greta.goracci@unibz.it}
}
