% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arbitration-methods.r
\name{train_ade}
\alias{train_ade}
\title{Training procedure of for ADE}
\usage{
train_ade(form, train, specs, lambda, lfun, meta_model_type, num_cores)
}
\arguments{
\item{form}{formula;}

\item{train}{training data as a data frame;}

\item{specs}{a \code{\link{model_specs-class}} object class. It contains
the parameter setting specifications for training the ensemble;}

\item{lambda}{window size. Number of observations to compute
the recent performance of the base models, according to the
committee ratio \strong{omega}. Essentially, the top \emph{omega}
models are selected and weighted at each prediction instance, according
to their performance in the last \emph{lambda} observations.
Defaults to 50 according to empirical experiments;}

\item{lfun}{meta loss function - defaults to \strong{ae} (absolute error)}

\item{meta_model_type}{algorithm used to train meta models. Defaults to a
random forest (using ranger package)}

\item{num_cores}{A numeric value to specify the number of cores used to
train base and meta models. num_cores = 1
leads to sequential training of models. num_cores > 1
splits the training of the base models across num_cores cores.}
}
\description{
Base level models are trained according to \strong{specs},
and meta level models are trained using a blocked prequential
procedure in out-of-bag samples from the training data.
}
\keyword{internal}
