% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_examples.R
\name{ts_examples}
\alias{ts_examples}
\alias{ts_prcomp}
\alias{ts_dygraphs}
\alias{ts_forecast}
\alias{ts_seas}
\title{Principal Components, Dygraphs, Forecasts, Seasonal Adjustment}
\usage{
ts_prcomp(x, ...)

ts_dygraphs(x, ...)

ts_forecast(x, ...)

ts_seas(x, ...)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.}

\item{...}{further arguments, passed to the underlying function. For help,
consider these functions, e.g., \link[stats:prcomp]{stats::prcomp}.}
}
\value{
Usually, a ts-boxable time series, with the same class as the input.
\code{ts_dygraphs} draws a plot.
}
\description{
Example Functions, Generated by \link{ts_}. \code{ts_prcomp} calculates the principal
components of multiple time series, \code{ts_dygraphs} generates an interactive
graphical visualization, \code{ts_forecast} return an univariate forecast,
\code{ts_seas} the seasonally adjusted series.
}
\details{
With the exception of \code{ts_prcomp}, these functions depend on external
packages.
}
\examples{
\donttest{
ts_plot(
  ts_scale(ts_c(
    Male = mdeaths,
    Female = fdeaths,
    `First principal compenent` = -ts_prcomp(ts_c(mdeaths, fdeaths))[, 1]
  )),
  title = "Deaths from lung diseases",
  subtitle = "Normalized values"
)

ts_plot(ts_c(
  male = mdeaths, female = fdeaths,
  ts_forecast(ts_c(`male (fct)` = mdeaths,  `female (fct)` = fdeaths))),
  title = "Deaths from lung diseases",
  subtitle = "Exponential smoothing forecast"
)

ts_plot(
  `Raw series` = AirPassengers,
  `Adjusted series` = ts_seas(AirPassengers),
  title = "Airline passengers",
  subtitle = "X-13 seasonal adjustment"
)


ts_dygraphs(ts_c(mdeaths, EuStockMarkets))
}
}
\seealso{
\href{https://www.tsbox.help/articles/ts-functions.html}{Vignette} on how
to make arbitrary functions ts-boxable.
}
