% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{tssim_event_sync}
\alias{tssim_event_sync}
\title{Event synchronization measure}
\usage{
tssim_event_sync(
  tts1,
  tts2,
  tau_max = 1,
  normalization = c("both", "min", "none")
)
}
\arguments{
\item{tts1}{Time indices marking events in time series 1}

\item{tts2}{Time indices marking events in time series 2}

\item{tau_max}{Max tau to be considered}

\item{normalization}{Forms of normalization after the co-occurrence count.
Possible values "both" (default), "min", and "none". The Default is "both",
the original normalization defined by Quiroga et al: sqrt(N1*N2). This
normalization might be problematic when both time series have very different
number of events. Another possibility is to normalize the count by the "min"
length between both series. The interpretation now takes into account only
the series with less events. For example, considering two series, one with
many events and another with just a single event, the results can be 1
(total sync). The option "none" means no normalization and the method
returns the total count of synchronized events.}
}
\value{
Synchronization-based similarity
}
\description{
This function is an adapted version of the coocmetric function from
the package mmpp. The differences are the introduction of a tau_max
limitation factor and the optional normalization.
}
\details{
Quiroga, R. Q., Kreuz, T., & Grassberger, P. (2002). Event synchronization:
a simple and fast method to measure synchronicity and time delay patterns.
Physical review E, 66(4), 041904.

Boers, N., Goswami, B., Rheinwalt, A., Bookhagen, B., Hoskins, B., & Kurths,
J. (2019). Complex networks reveal global pattern of extreme-rainfall
teleconnections. Nature, 566(7744), 373-377.
}
