% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{tsdist_nmi}
\alias{tsdist_nmi}
\title{Normalized mutual information distance}
\usage{
tsdist_nmi(
  ts1,
  ts2,
  nbins = c("sturges", "freedman-diaconis", "scott"),
  normalization = c("sum", "min", "max", "sqrt"),
  method = "emp"
)
}
\arguments{
\item{ts1}{Array. Time series 1}

\item{ts2}{Array. Time series 2}

\item{nbins}{The number of bins used for the discretization of both time series.
It can be a positive integer or a string with one of the three rules
"sturges" (default), "freedman-diaconis", or "scott".}

\item{normalization}{The mutual information (I) normalization method.
Options are "sum" (default) 1-(2I/(h1+h2)), "min" 1-(I/min(h1,h2)), "max"
1-(I/max(h1,h2)), and "sqrt" 1-(I/sqrt(h1*h2)).}

\item{method}{The name of the entropy estimator used in the functions
mutinformation() and entropy() from the infotheo package.}
}
\value{
Distance
}
\description{
Calculates the normalized mutual information (NMI) and returns it as distance
1 - NMI.
}
