% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{tsdist_es}
\alias{tsdist_es}
\title{Event synchronization distance test.}
\usage{
tsdist_es(
  ets1,
  ets2,
  tau_max = +Inf,
  method = c("quiroga", "boers"),
  sig_test = FALSE,
  reps = 100,
  sig_level = 0.01
)
}
\arguments{
\item{ets1}{Event time series 1 (one means an event, or zero otherwise)}

\item{ets2}{Event time series 2 (one means an event, or zero otherwise)}

\item{tau_max}{The maximum tau allowed ()}

\item{method}{"quiroga" (default) for the default co-occurrence count and
normalization or "boers" for the co-occurrence count with tau_max and no
normalization.}

\item{sig_test}{Run a significance test. Return 0 if significant or 1 otherwise.}

\item{reps}{Number of repetitions to construct the confidence interval}

\item{sig_level}{The significance level to test if correlation is significant.}
}
\value{
distance
}
\description{
Quiroga, R. Q., Kreuz, T., & Grassberger, P. (2002). Event synchronization:
a simple and fast method to measure synchronicity and time delay patterns.
Physical review E, 66(4), 041904.
}
\details{
Boers, N., Goswami, B., Rheinwalt, A., Bookhagen, B., Hoskins, B., & Kurths,
J. (2019). Complex networks reveal global pattern of extreme-rainfall
teleconnections. Nature, 566(7744), 373-377.
}
