% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power_sim}
\alias{power_sim}
\title{Run Power Simulations}
\usage{
power_sim(
  model,
  phase_eff,
  target_effect,
  nsubj,
  nruns,
  outfile = sprintf("\%s_\%s_\%s_\%04d_128_\%05d_\%s_\%d.rds", model,
    sprintf("\%0.2f~\%0.2f~\%0.2f~\%0.2f", phase_eff[1], phase_eff[2], phase_eff[3],
    phase_eff[4]), target_effect, nsubj, nruns, Sys.info()[["nodename"]], Sys.getpid())
)
}
\arguments{
\item{model}{Which type of model to fit: use 'lmem' for linear
mixed-effects model and 'clmm' for cumulative link mixed-effects
model.}

\item{phase_eff}{A four-element vector, each element of which
specifies the illusory truth effect at the corresponding phase,
on the log odds scale (see \code{\link{gen_data}}).}

\item{target_effect}{Which effect to test, the main effect
(\code{'main'}) or the interaction effect (\code{'interaction'}).}

\item{nsubj}{Number of subjects.}

\item{nruns}{How many simulations to run.}

\item{outfile}{Name of output file; \code{NULL} to return the
simulation results.}
}
\value{
Either the name of the outfile (if \code{outfile} is
  non-null) or the results of the simulation (a matrix containing
  results of \code{\link{fit_lmem}} or \code{\link{fit_clmm}}).
}
\description{
Run Power Simulations
}
\examples{
set.seed(62)
power_sim("lmem", c(0, .14, .14, .14), "main", 40, 1, NULL)

}
