% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{allsimp.emmc}
\alias{allsimp.emmc}
\title{Custom Contrast Function for emmeans}
\usage{
allsimp.emmc(levels, ...)
}
\arguments{
\item{levels}{Interaction levels (should be of length 8).}

\item{...}{Any other arguments (NB: currently ignored).}
}
\value{
A data frame to be passed to the \code{specs} argument of
  \code{\link[emmeans]{emmeans}}, each column of which represents
  predictor codings that contrast the illusory truth effect across
  two intervals.
}
\description{
Create a contrast matrix for equivalence test of a 2x4
interaction.
}
\details{
Runs all six ways of comparing the simple effects of
the two-level factor. For use with the emmeans package.
}
\examples{
library(ordinal)
library(emmeans)

## create data frame with predictor codings
moddata <- get_model_data()

## use 'allsimp' with emmeans for equivalence test
mod_emm <- emmeans(truth_trajectory_models[["ix2"]],
                   allsimp ~ Rep * Int, data = moddata)

mod_emm

}
