% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropicalsparse.storage.R
\name{tropicalsparse.storage}
\alias{tropicalsparse.storage}
\title{Storage Techniques}
\usage{
tropicalsparse.storage(M, store, algebraType)
}
\arguments{
\item{M}{is Matrix}

\item{store}{is storage technique.}

\item{algebraType}{is string input that can be \code{minplus} or \code{maxplus}.}
}
\value{
Returns a list \code{result} that contains three arrays depends upon the \code{store} input.
}
\description{
\code{tropicalsparse.storage} function is used to apply \code{coo}, \code{csr} and \code{csc}
storage techniques on the sparse matrix in Tropical Algebra.
}
\details{
The function \code{tropicalsparse.storage} recieves a matrix as first input, storage technique as
second input and the type of Tropical Algebra as third input. All the inputs are compulsory. \code{store} can
be \code{coo}, \code{csr} and \code{csc}. \code{algebraType} is used to specify type of Tropical Algebra. This
can be \code{minplus} or \code{maxplus}. For more details about \code{algebraType}, see \code{detail} section of
\code{\link{check.infinityM}} or \code{\link{check.infinityV}}. If store is equal to \code{coo} then the
function returns a list containing three arrays that are \code{row_Indices_COO}, \code{col_Indices_COO} and
\code{values_COO}. If store is equal to \code{csc} then the function returns a list containing three arrays
that are \code{col_Pointer_CSC}, \code{row_Indices_CSC} and \code{values_CSC}. If store is equal to \code{csr}
then the function returns a list containing three arrays that are \code{row_Pointer_CSR},
\code{col_Indices_CSR} and \code{values_CSR}. These storage techniques are especially designed for sparse
matrices and are very helpful and time saving.
}
\examples{
a <- matrix(data = c(2, Inf, Inf, 0, Inf, Inf, Inf, 10, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

tropicalsparse.storage(a, 'coo', 'minplus')

# $row_Indices_COO
# [1] 1 2 3

# $col_Indices_COO
# [1] 1 1 2

# $values_COO
# [1]  2  0 10

}
\seealso{
\code{\link{tropicalsparse.add}}, \code{\link{tropicalsparse.mv}}.
}
