% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{basedata}
\alias{basedata}
\title{Vine's U.S. basing data}
\format{
A data frame with country-base observations including the following variables:
\describe{
\item{\code{countryname}}{A character vector of country names.}
\item{\code{ccode}}{A numeric vector of Correlates of War country codes.}
\item{\code{iso3c}}{A character vector of ISO three character country codes.}
\item{\code{basename}}{Name of the facility.}
\item{\code{lat}}{The facility's latitude.}
\item{\code{lon}}{The facility's longitude.}
\item{\code{base}}{Binary indicator identifying the facility as a major base or not.}
\item{\code{lilypad}}{A binary indicator identifying the facility as a lilypad or not. Vine codes lilypads as less than 200 personnel or "other site" designation in Pentagon reports.}
\item{\code{fundedsite}}{A binary variable indicating whether or not the facility is a host-state base funded by the US.}
}
}
\source{
\url{https://aura.american.edu/articles/online_resource/Lists_of_U_S_Military_Bases_Abroad_1776-2020/23856486}
}
\usage{
basedata
}
\value{
Returns the full data frame containing country observations of US military bases from the Cold War period through 2018.
}
\description{
\code{basedata} returns a data frame containing David Vine's US basing data.
}
\keyword{datasets}
