% Generated by roxygen2 (4.0.2): do not edit by hand
\name{argos.sigma}
\alias{argos.sigma}
\title{Assign numeric values for Argos "class"}
\usage{
argos.sigma(x, sigma = c(100, 80, 50, 20, 10, 4, 2), adjust = 111.12)
}
\arguments{
\item{x}{factor of Argos location quality "classes"}

\item{sigma}{numeric values (by default in kilometres)}

\item{adjust}{a numeric adjustment to convert from kms to degrees}
}
\value{
Numeric values for given levels.
}
\description{
Assign numeric values for Argos "class" by matching the levels available to
given numbers. An adjustment is made to allow sigma to be specified in
kilometeres, and the values returned are the approximate values for longlat
degrees.  It is assumed that the levels are part of an "ordered" factor from
least precise to most precise.
}
\details{
The available levels in Argos are \code{levels=c("Z", "B", "A", "0", "1",
"2", "3")}.

The actual sigma values given by default are (as far as can be determined) a
reasonable stab at what Argos believes.
}
\examples{
cls <- ordered(sample(c("Z", "B", "A", "0", "1", "2", "3"), 30,
                      replace=TRUE),
               levels=c("Z", "B", "A", "0", "1", "2", "3"))
argos.sigma(cls)
}
\keyword{manip}

