\name{getMatPseudo}
\alias{getMatPseudo}
\title{
Generates Case-Pseudo-Control Matrix
}
\description{
Generates a matrix containing the genotypes of the cases and the corresponding three pseudo-controls (i.e.
the genotypes of the children and the respective corresponding three genotypes not transmitted from the parents).
}
\usage{
getMatPseudo(mat.snp)
}

\arguments{
  \item{mat.snp}{a numeric matrix in which each column represents a SNP. Each column must be
    a numeric vector of length \eqn{3 * t} representing a SNP genotyped at \eqn{t} trios. Each of the \eqn{t}
    blocks must consist of the genotypes of father, mother, and offspring
    (in this order). The genotypes must be coded by 0, 1, and 2. Missing values are allowed and need to be coded by \code{NA}.
    This matrix might be generated from a ped-file by, e.g., employing \code{\link{ped2geno}}.
  }
}

\value{
A matrix with \eqn{4 * t} rows, in which each block of four consecutive rows consists of the genotypes of the SNPs in \code{mat.snp}
for the case and the three matched pseudo-controls corresponding to the respective block in \code{mat.snp}.
}

\author{
Holger Schwender, \email{holger.schwender@udo.edu}
}

\seealso{
\code{\link{colTDT}}, \code{\link{colTDT2way}}, \code{\link{colGxE}}
}

\examples{
# Load the simulated data.
data(trio.data)

# The matrix with the genotypes of the offspring and the three
# pseudo-controls for each of the trios in mat.test can be
# generated by
matPseudo <- getMatPseudo(mat.test)
} 



\keyword{manip}
