% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognostics.R
\name{cogRange}
\alias{cogRange}
\title{Compute Range Cognostic}
\usage{
cogRange(x, desc = "range (max - min)", group = "common",
  defLabel = FALSE, defActive = TRUE, filterable = TRUE,
  sortable = TRUE, log = FALSE)
}
\arguments{
\item{x}{numeric vector from which to compute the range}

\item{desc, group, defLabel, defActive, filterable, sortable, log}{arguments passed to \code{\link{cog}}}
}
\description{
Compute range to be used as cognostics in a trelliscope display.
}
\examples{
d <- stack(data.frame(EuStockMarkets))
d$time <- rep(as.numeric(time(EuStockMarkets)), 4)
d$year <- floor(d$time)

byIndexYear <- divide(d, by = c("ind", "year"))

cogFn <- function(x)
  list(lormse = cogLoessRMSE(values ~ time, data = x, span = 0.3, degree = 2),
       slope  = cogSlope(values ~ time, data = x),
       range  = cogRange(x$values),
       mean   = cogMean(x$values),
       max    = cog(max(x$values, na.rm = TRUE), desc = "max value"))

applyCogFn(cogFn, byIndexYear[[1]])

library(lattice)
panelFn <- function(x)
  xyplot(values ~ time, data = x,
    panel = function(x, y, ...) {
      panel.xyplot(x, y, ...)
      panel.loess(x, y, span = 0.3,
        degree = 2, evaluation = 200, col = "black")
    })

vdbConn(tempfile(), autoYes = TRUE)
makeDisplay(byIndexYear, name = "ts_index_year",
  cogFn = cogFn, panelFn = panelFn)

\dontrun{
# sort and fiter the index/year panels by slope and loess RMSE
view(name = "ts_index_year")
}
}
\seealso{
\code{\link{cog}}
}

