% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_del_width.R
\name{max_del_width}
\alias{max_del_width}
\title{Maximum difference of widths of a phylogenetic tree}
\usage{
max_del_width(phy, normalization = "none")
}
\arguments{
\item{phy}{phylogeny or ltable}

\item{normalization}{"none" or "tips", in which case the resulting statistic
is divided by the number of tips in the tree.}
}
\value{
maximum difference of widths
}
\description{
Calculates the maximum difference of widths of a phylogenetic
tree. First, the widths are calculated by collecting the depth of each node
and tip across the entire tree, where the depth represents the distance
(in nodes) to the root. Then, the width represents the number of occurrences
of each possible depth. Then, we take the difference between each consecutive
width, starting with the first width. The maximum difference is then
returned - whereas the original statistic designed by Colijn and Gardy used
the absolute maximum difference, we here use the modified version as
introduced in Fischer 2023: this returns the maximum value, without
absoluting negative widths. This ensures that this metric is a proper
(im)balance metric, following Fischer 2023.
}
\references{
C. Colijn and J. Gardy. Phylogenetic tree shapes resolve disease
transmission patterns. Evolution, Medicine, and Public Health,
2014(1):96-108, 2014. ISSN 2050-6201. doi: 10.1093/emph/eou018.

Fischer, M., Herbst, L., Kersting, S., Kühn, A. L., & Wicke, K. (2023).
Tree Balance Indices: A Comprehensive Survey.
}
