% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colless.R
\name{colless_corr}
\alias{colless_corr}
\title{Corrected Colless index of (im)balance.}
\usage{
colless_corr(phy, normalization = "none")
}
\arguments{
\item{phy}{phylo object or ltable}

\item{normalization}{A character string equals to "none" (default) for no
normalization or "yule", in which case the obtained index is divided by
the Yule expectation.}
}
\value{
corrected colless index
}
\description{
The Corrected Colless index is calculated as the sum of
\eqn{abs(L - R)} over all nodes, corrected for tree size by dividing over
\eqn{(n-1) * (n-2)}, where n is the number of nodes.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
balanced_tree <- treestats::create_fully_balanced_tree(simulated_tree)
unbalanced_tree <- treestats::create_fully_unbalanced_tree(simulated_tree)
colless_corr(balanced_tree)
colless_corr(unbalanced_tree) # should be higher
}
\references{
Heard, Stephen B. "Patterns in tree balance among cladistic,
phenetic, and randomly generated phylogenetic trees." Evolution 46.6 (1992):
1818-1826.
}
