% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectCharacterType.R
\name{detectAllCharacters}
\alias{detectAllCharacters}
\title{Apply detectCharacterType over an entire matrix}
\usage{
detectAllCharacters(mat, repeatsAsDiscrete = TRUE, cutoff = 0.1)
}
\arguments{
\item{mat}{A matrix of data}

\item{repeatsAsDiscrete}{If TRUE, consider numeric variables that repeat values exactly as discrete; see cutoff}

\item{cutoff}{Cutoff value for deciding if numeric data might actually be descrete: if nlev is the number of levels and n the length of dat, then nlev / n should exceed cutoff, or the data will be classified as discrete}
}
\value{
Vector of either "discrete" or "continuous" for each variable in matrix
}
\description{
Apply detectCharacterType over an entire matrix
}
\examples{
data(anolis)
detectAllCharacters(anolis$dat)
}

