% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write-methods.R
\name{writeTree}
\alias{writeTree}
\title{Write a Newick tree}
\usage{
writeTree(tree, file, ndLabels = function(nd) {     return(NULL) })
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{file}{file path}

\item{ndLabels}{node label function}
}
\description{
Creates a Newick tree from a \code{TreeMan} object.
}
\details{
The \code{ndLabels} argument can be used to add a user defined node label in
the Newick tree. It should take only 1 argument, \code{nd}, the node represented as a list.
It should only return a single character value that can be added to a newick string.
}
\examples{
library(treeman)
tree <- randTree(10)
ndLabels <- function(n) {
paste0(n[['id']], '_ndlabel')
}
writeTree(tree, file='example.tre', ndLabels)
file.remove('example.tre')
}
\seealso{
\code{\link{readTree}}, \code{\link{randTree}}, \url{https://en.wikipedia.org/wiki/Newick_format}
}

