% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setNdsOther}
\alias{setNdsOther}
\title{Set a user defined slot for multiple nodes}
\usage{
setNdsOther(tree, ids, vals, slt_nm, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{id sof the nodes}

\item{vals}{data for slot}

\item{slt_nm}{slot name}

\item{...}{\code{plyr} arguments}
}
\description{
Return a tree with a user defined slot for node IDs.
}
\details{
Runs \code{setNdOther()} over multiple nodes. Parellizable.
}
\examples{
library(treeman)
tree <- randTree(10)
vals <- sample(0:1, size=tree['nall'], replace=TRUE)
tree <- setNdsOther(tree, tree['all'], vals, 'binary_val')
(getNdsSlt(tree, ids=tree['all'], slt_nm='binary_val'))
}
\seealso{
\code{\link{setNdOther}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}

