% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate.R
\name{tr_real_yield_curve}
\alias{tr_real_yield_curve}
\title{Daily treasury par real yield curve rates}
\source{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\usage{
tr_real_yield_curve(date = NULL)
}
\arguments{
\item{date}{(\code{character(1)} | \code{numeric(1)}) date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing the rates or \code{NULL} when no entries were found.
}
\description{
The par real curve, which relates the par real yield on a Treasury Inflation
Protected Security (TIPS) to its time to maturity, is based on the closing market
bid prices on the most recently auctioned TIPS in the over-the-counter market.
The par real yields are derived from input market prices, which are indicative
quotations obtained by the Federal Reserve Bank of New York at approximately 3:30 PM
each business day. Treasury began publishing this series on January 2, 2004.
At that time Treasury released 1 year of historical data.
}
\examples{
\donttest{
# get data for a single month
tr_real_yield_curve("202201")
# or for the entire year
tr_real_yield_curve(2022)
}
}
\seealso{
Other interest rate: 
\code{\link{tr_bill_rates}()},
\code{\link{tr_long_term_rate}()},
\code{\link{tr_real_long_term}()},
\code{\link{tr_yield_curve}()}
}
\concept{interest rate}
