% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_apollonius.R
\name{plot_apollonius}
\alias{plot_apollonius}
\title{Plot Apollonius Diagram}
\usage{
plot_apollonius(points, weights, show_points = TRUE,
  show_weights = TRUE, add_to_weights = 0, add = FALSE, col = 4,
  lwd = 1.5, ...)
}
\arguments{
\item{points}{A two-column matrix containing the 2d points.}

\item{weights}{A vector of weights for the points.}

\item{show_points}{Logical. Should the points be displayed in the plot?
Defaults to TRUE.}

\item{show_weights}{Logical. Should the weights be displayed in the plot?
Defaults to TRUE.}

\item{add_to_weights}{A value added to the weights to make the plot
more informative.}

\item{add}{Logical. Should the plot be added to the current device?
Defaults to FALSE.}

\item{col}{The colour for the cell boundaries.}

\item{lwd}{The line width for the cell boundaries.}

\item{...}{Further parameters to the base plot if \code{add} is \code{FALSE}.}
}
\description{
Plots the Apollonius diagram, a.k.a. (additively) weighted Voronoi diagram, based
on a matrix of points (centers) in 2d and their weights.
}
\details{
For points \eqn{x_1, \ldots, x_n}{x_1, ..., x_n} with weights \eqn{w_1, \ldots, w_n}
The $i$-th cell of the Apollonius diagram contains all the points x that satisfy
\deqn{\|x-x_i\|-w_i < \|x-x_j\|-w_j}{||x-x_i|| - w_i < ||x-x_j|| - w_j} 
for all  \eqn{j \neq i}{j != i}. Its boundaries are hyperbola segments.

If \code{show_weights} is \code{TRUE}, grey circles of radii \code{weights + add_to_weights}
are plotted around the points. Negative radii are set to zero.
}
\note{
This function requires the Computational Geometry Algorithms Library (CGAL),
      available at \url{https://www.cgal.org}. Adapt the file src/Makevars according
      to the instructions given there and re-install from source.
}
\examples{
\dontrun{
w <- c(0.731, 0.0372, 0.618, 0.113, 0.395, 0.222, 0.124, 0.101, 0.328, 0)
points <- matrix(runif(20), 10, 2)
plot_apollonius(points, w, add_to_weights = -0.1)}

}
\references{
Menelaos Karavelas and Mariette Yvinec. 2D Apollonius Graphs 
            (Delaunay Graphs of Disks). In CGAL User and Reference Manual.
            CGAL Editorial Board, 4.12 edition, 2018
}
\author{
Valentin Hartmann \email{valentin.hartmann@epfl.ch} (most of the code)\cr
        Dominic Schuhmacher \email{schuhmacher@math.uni-goettingen.de} (R-port)
}
\keyword{Apollonius}
\keyword{Voronoi}
\keyword{apollonius}
\keyword{diagram,}
\keyword{graph,}
\keyword{tesselation}
\keyword{weighted}
