% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trampoline.R
\name{trm_tailcall}
\alias{trm_tailcall}
\title{Flag a tail call}
\usage{
trm_tailcall(x)
}
\arguments{
\item{x}{A recursive call within generator fed to \code{\link[=trampoline]{trampoline()}}}
}
\value{
\code{x} with added class attribute 'trampoline_tailcall'
}
\description{
If you can specify your recursive function such that the
recursive call is in 'tail position' (that is, the very
last operation in your function), you can take advantage
of tail call optimization. Just wrap your recursive call
in \code{trm_tailcall()}
}
\examples{
trampoline(factorial(13),
           factorial = function(n, x = 1) {
             force(x) ## necessary thanks to R's lazy evaluation
             if(n <= 1) {
               return(trm_return(x))
             }
             val <- trm_tailcall(factorial(n - 1, x * n))
             return(val)
           })
}
