% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.tramME}
\alias{confint.tramME}
\title{Confidence intervals for tramME model parameters}
\usage{
\method{confint}{tramME}(
  object,
  parm = NULL,
  level = 0.95,
  pargroup = c("all", "fixef", "shift", "baseline", "ranef", "smooth"),
  type = c("Wald", "wald", "profile"),
  estimate = FALSE,
  pmatch = FALSE,
  parallel = c("no", "multicore", "snow"),
  ncpus = getOption("profile.ncpus", 1L),
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{parm}{The indeces or names of the parameters of interest. See in details.}

\item{level}{Confidence level.}

\item{pargroup}{The name of the parameter group to return:
\itemize{
  \item all: All parameters.
  \item fixef: Fixed effects parameters.
  \item shift: Shift parameters.
  \item baseline: Parameters of the baseline transformation function.
  \item ranef: Variance components parameters.
  \item smooth: Paramaters that belong to the smooth shift terms
    (both FE and smoothing parameters).
}}

\item{type}{Type of the CI: either Wald or profile.}

\item{estimate}{Logical, add the point estimates in a thrid column.}

\item{pmatch}{Logical. If \code{TRUE}, partial name matching is allowed.}

\item{parallel}{Method for parallel computation.}

\item{ncpus}{Number of cores to use for parallel computation.}

\item{...}{Optional parameters.}
}
\value{
A matrix with lower and upper bounds.
}
\description{
Confidence intervals for model parameters on their original scale.
Either Wald CI or profile CI by root finding. Multicore computations
are supported in the case of profile confidence intervals, but snow
support is yet to be implemented.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
confint(fit)
confint(fit, pargroup = "shift", estimate = TRUE)
exp(confint(fit, 1:2, pargroup = "ranef")) ## CIs for the SDs of the REs
}
