% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{anova.tramME}
\alias{anova.tramME}
\title{Comparison of nested tramME models.}
\usage{
\method{anova}{tramME}(object, object2, ...)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{object2}{A \code{tramME} object.}

\item{...}{Optional arguments, for compatibility with the generic. (Ignored)}
}
\value{
A \code{data.frame} with the calculated statistics.
}
\description{
Calculates information criteria and LR ratio test for nested tramME models.
The calculation of the degrees of freedom is problematic, because the
parameter space is restricted.
}
\details{
Currently only supports the comparison of two models. Additional arguments
will be ignored.

The nestedness of the models is not checked.
}
\examples{
data("sleepstudy", package = "lme4")
mod1 <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
mod2 <- LmME(Reaction ~ Days + (Days || Subject), data = sleepstudy)
anova(mod1, mod2)
}
