% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.gbm}
\alias{train.gbm}
\title{train.gbm}
\usage{
train.gbm(
  formula,
  data,
  distribution = "bernoulli",
  weights,
  var.monotone = NULL,
  n.trees = 100,
  interaction.depth = 1,
  n.minobsinnode = 10,
  shrinkage = 0.001,
  bag.fraction = 0.5,
  train.fraction = 1,
  cv.folds = 0,
  keep.data = TRUE,
  verbose = F,
  class.stratify.cv = NULL,
  n.cores = NULL
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{data}{an optional data frame containing the variables in the model.}

\item{distribution}{Either a character string specifying the name of the distribution to use or a list with a component name specifying the distribution and any additional parameters needed.}

\item{weights}{an optional vector of weights to be used in the fitting process. Must be positive but do not need to be normalized.}

\item{var.monotone}{an optional vector, the same length as the number of predictors, indicating which variables have a monotone increasing (+1), decreasing (-1), or arbitrary (0) relationship with the outcome.}

\item{n.trees}{Integer specifying the total number of trees to fit. This is equivalent to the number of iterations and the number of basis functions in the additive expansion. Default is 100.}

\item{interaction.depth}{Integer specifying the maximum depth of each tree (i.e., the highest level of variable interactions allowed). A value of 1 implies an additive model, a value of 2 implies a model with up to 2-way interactions, etc. Default is 1.}

\item{n.minobsinnode}{Integer specifying the minimum number of observations in the terminal nodes of the trees. Note that this is the actual number of observations, not the total weight.}

\item{shrinkage}{a shrinkage parameter applied to each tree in the expansion. Also known as the learning rate or step-size reduction; 0.001 to 0.1 usually work, but a smaller learning rate typically requires more trees. Default is 0.1.}

\item{bag.fraction}{the fraction of the training set observations randomly selected to propose the next tree in the expansion. This introduces randomnesses into the model fit.}

\item{train.fraction}{The first train.fraction * nrows(data) observations are used to fit the gbm and the remainder are used for computing out-of-sample estimates of the loss function.}

\item{cv.folds}{Number of cross-validation folds to perform. If cv.folds>1 then gbm, in addition to the usual fit, will perform a cross-validation, calculate an estimate of generalization error returned in cv.error.}

\item{keep.data}{a logical variable indicating whether to keep the data and an index of the data stored with the object. Keeping the data and index makes subsequent calls to gbm.more faster at the cost of storing an extra copy of the dataset.}

\item{verbose}{Logical indicating whether or not to print out progress and performance indicators (TRUE). If this option is left unspecified for gbm.more, then it uses verbose from object. Default is FALSE.}

\item{class.stratify.cv}{Logical indicating whether or not the cross-validation should be stratified by class.}

\item{n.cores}{The number of CPU cores to use. The cross-validation loop will attempt to send different CV folds off to different cores. If n.cores is not specified by the user, it is guessed using the detectCores function in the parallel package.}
}
\value{
A object gbm.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[gbm]{gbm}}.
}
\note{
The parameter information was taken from the original function \code{\link[gbm]{gbm}}.
}
\examples{

# Classification
data <- iris
n <- nrow(data)

sam <- sample(1:n, n*0.75)
training <- data[sam,]
testing <- data[-sam,]

model <- train.gbm(formula = Species ~ ., data = training)
model
predict <- predict(object = model, testing)
predict

# Regression
len <- nrow(swiss)
sampl <- sample(x = 1:len,size = len*0.10,replace = FALSE)
ttesting <- swiss[sampl,]
ttraining <- swiss[-sampl,]
model.gbm <- train.gbm(Infant.Mortality~., ttraining, distribution = "gaussian")
prediction <- predict(model.gbm, ttesting)
prediction

}
\seealso{
The internal function is from package \code{\link[gbm]{gbm}}.
}
