% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRapp.R
\name{trackeRapp}
\alias{trackeRapp}
\alias{trackeR_app}
\title{Launch the \pkg{trackeRapp} interface}
\usage{
trackeRapp(quiet = TRUE)

trackeR_app(quiet = TRUE)
}
\arguments{
\item{quiet}{If \code{TRUE} (default), then warnings and errors
while using the interface are printed in standard output. If
\code{FALSE}, then all warnings and errors are suppressed.}
}
\description{
\pkg{trackeRapp} provides an integrated dashboard and workflow for
the analysis of running, cycling and swimming data from GPS-enabled tracking
devices through the \code{trackeR} R package. \code{trackerRapp} or
\code{trackeR_app} launches the interface.
}
\section{Getting started}{

Once the interface launches, you may
experiment with the interface by hitting "Load" and then
"Upload sample dataset".

See the \code{"tour de trackeRapp"} pages at
\url{https://trackerproject.github.io/trackeRapp/} for tutorial
videos, explanation of the workflow and visualizations that
\pkg{trackeRapp} offers, and to, generally, learn more about
\pkg{trackeRapp} and all of its capabilities.
}

\section{Video channel}{

\pkg{trackeRapp} has a dedicated YouTube channel at
\url{https://www.youtube.com/channel/UCY6y-pw8d1kek1WAIWiVhhw}. The
channel features video tutorials about \pkg{trackeRapp} and the
workflow it provides.
}

\section{Development notes and acknowledgements}{

\code{trackeRapp} has been designed and developed by Robin Hornak
and Ioannis Kosmidis, while Robin Hornak was completing his
undergraduate research project in the Department of Statistical
Science, University College London under the supervision of Ioannis
Kosmidis. Ioannis Kosmidis has been supported by the Alan Turing
Institute under the EPSRC grant EP/N510129/1 (Turing award number
TU/B/000082) and University of Warwick. Robin Hornak and Ioannis
Kosmidis have also been supported by University of Warwick through
a Warwick Impact Fund Award that runs from May 2018 to December
2019. The support of the aforementioned organizations is greatly
acknowledged.
}

\examples{

if (interactive()) {
  trackeRapp(quiet = TRUE)
}

if (interactive()) {
  trackeR_app(quiet = FALSE)
}

# Experiment with the interface by hitting "Load" and then
# "Upload sample dataset".

}
\references{
Frick, H., Kosmidis, I. (2017). trackeR: Infrastructure for Running
and Cycling Data from GPS-Enabled Tracking Devices in
R. \emph{Journal of Statistical Software}, \bold{82}(7),
1--29. doi:10.18637/jss.v082.i07

Kosmidis, I., and Passfield, L. (2015). Linking the Performance of
Endurance Runners to Training and Physiological Effects via
Multi-Resolution Elastic Net. \emph{ArXiv e-print}
arXiv:1506.01388.
}
