% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionProfile.R, R/zzz_aliases.R
\name{distribution_profile}
\alias{distribution_profile}
\alias{distrProfile}
\alias{distributionProfile}
\title{Generate training distribution profiles.}
\usage{
distribution_profile(object, session = NULL, what = NULL,
  grid = NULL, parallel = FALSE, unit_reference_sport = NULL)

distributionProfile(object, session = NULL, what = NULL, grid = NULL,
  parallel = FALSE, unit_reference_sport = NULL)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be used,
defaults to all sessions.}

\item{what}{The variables for which the distribution profiles
should be generated. Defaults to all variables in
\code{object} (\code{what = NULL}).}

\item{grid}{A named list containing the grid values for the
variables in \code{what}. If \code{NULL} (default) the grids
for the variables in \code{what} are inferred from
\code{object}.}

\item{parallel}{Logical. Should computation be carried out in
parallel? Default is \code{FALSE}.}

\item{unit_reference_sport}{The sport to inherit units from
(default is taken to be the most frequent sport in
\code{object}).}
}
\value{
An object of class \code{distrProfile}.

Object:

A named list with one or more components, corresponding to the
value of \code{what}. Each component is a matrix of dimension
\code{g} times \code{n}, where \code{g} is the length of the grids
set in \code{grid} (or 201 if \code{grid = NULL}) and \code{n} is
the number of sessions requested in the \code{session} argument.

Attributes:

Each \code{distrProfile} object has the following attributes:

\itemize{

\item \code{sport}: the sports corresponding to the columns of each
list component

\item \code{session_times}: the session start and end times
correspoding to the columns of each list component

\item \code{unit_reference_sport}: the sport where the units have
been inherited from

\item \code{operations}: a list with the operations that have been
applied to the object. See \code{\link{get_operations.distrProfile}}

\item \code{limits}: The variable limits that have been used for the
computation of the distribution profiles

\item \code{units}: an object listing the units used for the
calculation of distribution profiles. These is the output of
\code{\link{get_units}} on the corresponding
\code{\link{trackeRdata}} object, after inheriting units from
\code{unit_reference_sport}.

}
}
\description{
Generate training distribution profiles.
}
\examples{
data('run', package = 'trackeR')
dProfile <- distribution_profile(run, what = c("speed", "cadence_running"))
\dontrun{
plot(dProfile, smooth = FALSE)
}
}
\references{
Kosmidis, I., and Passfield, L. (2015). Linking the Performance of
Endurance Runners to Training and Physiological Effects via
Multi-Resolution Elastic Net. \emph{ArXiv e-print}
arXiv:1506.01388.

Frick, H., Kosmidis, I. (2017). trackeR: Infrastructure for Running
and Cycling Data from GPS-Enabled Tracking Devices in
R. \emph{Journal of Statistical Software}, \bold{82}(7),
1--29. doi:10.18637/jss.v082.i07
}
