% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_zones.R
\name{zones}
\alias{zones}
\title{Time spent in training zones.}
\usage{
zones(object, session = NULL, what = c("speed", "heart_rate"),
  breaks = NULL, parallel = FALSE, n_zones = 9,
  unit_reference_sport = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be plotted,
defaults to all sessions.}

\item{what}{A vector of variable names.}

\item{breaks}{A list of breakpoints between zones, corresponding to
the variables in \code{what}.}

\item{parallel}{Logical. Should computation be carried out in
parallel? If \code{TRUE} computation is performed in parallel
using the backend provided to \code{\link{foreach}}. Default is
\code{FALSE}.}

\item{n_zones}{numeric that sets the number of zones for data to be
split into. Default is \code{9}.}

\item{unit_reference_sport}{The sport to inherit units from
(default is taken to be the most frequent sport in
\code{object}).}

\item{...}{Currently not used.}
}
\value{
An object of class \code{trackeRdataZones}.
}
\description{
Time spent in training zones.
}
\examples{
data('run', package = 'trackeR')
runZones <- zones(run, what = 'speed', breaks = list(speed = c(0, 2:6, 12.5)))
## if breaks is a named list, argument 'what' can be left unspecified
runZones <- zones(run, breaks = list(speed = c(0, 2:6, 12.5)))
## if only a single variable is to be evaluated, 'breaks' can also be a vector
runZones <- zones(run, what = 'speed', breaks = c(0, 2:6, 12.5))
plot(runZones)
}
\seealso{
\code{\link{plot.trackeRdataZones}}
}
