% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapKDE.R
\name{mapKDE}
\alias{mapKDE}
\title{Make simple maps of Kernel Density Estimates}
\usage{
mapKDE(KDE, colony = NULL, show = TRUE)
}
\arguments{
\item{KDE}{Simple feature MULTIPOLYGON or estUDm object. Must be output of
\code{\link{estSpaceUse}} function).}

\item{colony}{data.frame. Optional.'Latitude' and 'Longitude' locations to
display reference point of, for example, a breeding or tagging site.}

\item{show}{logical. show plot, or just save it. Note, saving plot only works
for Simple Features input. Default is TRUE.}
}
\value{
Returns a figure of either single map with all core ranges displayed
together, or a series of facetted maps, each of which shows a utilization
distribution corresponding to a level of ID in \emph{KDE}.
}
\description{
\code{mapKDE} uses output from \code{estSpaceUse} to create maps illustrating
 utilization distributions for each ID.
}
\details{
If the input is simple features polygons, these will be displayed for all IDs
 on same map. If input estUDm utilization distribution surface, each ID level
 gets its own facet displaying the full UD.
}
\examples{
## make some play data
dataGroup <- data.frame(Longitude = c(1, 1.01, 1.02, 1.04, 1.05, 1.03, 1), 
                       Latitude =  c(1, 1.01, 1.02, 1.03, 1.021, 1.01, 1),
                       ID = rep("A", 7),
                       DateTime = format(
                         lubridate::ymd_hms("2021-01-01 00:00:00") + 
                         lubridate::hours(0:6)
                         )
)
## project tracks
tracks <- projectTracks(dataGroup, projType = "azim", custom = TRUE)
## estimate utilization distributions for each track
KDE <- estSpaceUse(tracks, scale=10, levelUD = 50)
## map it
mapKDE(KDE)

}
\seealso{
\code{\link{estSpaceUse}}
}
