% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_fragments.R
\name{find_fragments}
\alias{find_fragments}
\title{Find fragment peaks}
\usage{
find_fragments(
  fragments_trace_list,
  smoothing_window = 21,
  minimum_peak_signal = 20,
  min_bp_size = 100,
  max_bp_size = 1000,
  ...
)
}
\arguments{
\item{fragments_trace_list}{A list of fragments_trace objects containing fragment data.}

\item{smoothing_window}{numeric: signal smoothing window size passed to pracma::savgol()}

\item{minimum_peak_signal}{numeric: minimum signal of the raw trace. To have no minimum signal set as "-Inf".}

\item{min_bp_size}{numeric: minimum bp size of peaks to consider}

\item{max_bp_size}{numeric: maximum bp size of peaks to consider}

\item{...}{pass additional arguments to pracma::findpeaks(), or change the default arguments
we set. minimum_peak_signal above is passed to pracma::findpeaks() as minpeakheight, and
peakpat has been set to '[+]\{6,\}[0]*[-]\{6,\}' so that peaks with flat tops are
still called, see https://stackoverflow.com/questions/47914035/identify-sustained-peaks-using-pracmafindpeaks}
}
\value{
a list of fragments_repeats objects.
}
\description{
Find fragment peaks in continuous trace data and convert to fragments_repeats
class.
}
\details{
\code{\link[=find_fragments]{find_fragments()}} takes in a list of fragments_trace objects and returns a list of new fragments_repeats objects.

This function is basically a wrapper around pracma::findpeaks. As mentioned above,
the default arguments arguments of pracma::findpeaks can be changed by passing them
to find_fragments with ... .

If too many and inappropriate peaks are being called, this may also be solved with the different repeat calling algorithms in \code{\link[=call_repeats]{call_repeats()}}.
}
\examples{
fsa_list <- lapply(cell_line_fsa_list[1], function(x) x$clone())

find_ladders(fsa_list)

fragments_list <- find_fragments(fsa_list,
  min_bp_size = 300
)


# Manually inspect the ladders
plot_traces(fragments_list,
  show_peaks = TRUE, n_facet_col = 1,
  xlim = c(400, 550), ylim = c(0, 1200)
)
}
