% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpModel.R
\docType{class}
\name{TxpModel-class}
\alias{TxpModel-class}
\alias{TxpModel}
\alias{txpSlices,TxpModel-method}
\alias{TxpModel-txpSlices}
\alias{txpSlices<-,TxpModel-method}
\alias{txpWeights,TxpModel-method}
\alias{txpWeights<-,TxpModel-method}
\alias{txpTransFuncs,TxpModel-method}
\alias{txpTransFuncs<-,TxpModel-method}
\alias{names,TxpModel-method}
\alias{names<-,TxpModel-method}
\alias{length,TxpModel-method}
\alias{merge,TxpModel,TxpModel-method}
\title{ToxPi Model}
\usage{
TxpModel(txpSlices, txpWeights = NULL, txpTransFuncs = NULL)

\S4method{txpSlices}{TxpModel}(x)

\S4method{txpSlices}{TxpModel}(x) <- value

\S4method{txpWeights}{TxpModel}(x, adjusted = FALSE)

\S4method{txpWeights}{TxpModel}(x) <- value

\S4method{txpTransFuncs}{TxpModel}(x)

\S4method{txpTransFuncs}{TxpModel}(x) <- value

\S4method{names}{TxpModel}(x)

\S4method{names}{TxpModel}(x) <- value

\S4method{length}{TxpModel}(x)

\S4method{merge}{TxpModel,TxpModel}(x, y)
}
\arguments{
\item{txpSlices}{Passed to \code{txpSlices} slot}

\item{txpWeights}{Passed to \code{txpWeights} slot}

\item{txpTransFuncs}{Passed to \code{txpTransFuncs} slot}

\item{x, y}{TxpModel object}

\item{value}{Replacement value}

\item{adjusted}{Scalar logical, should the returned weights be adjusted
such that they sum to 1?}
}
\description{
S4 class to store ToxPi models
}
\section{Functions}{
\itemize{
\item \code{txpSlices,TxpModel-method}: Return \code{txpSlices} slot

\item \code{txpWeights,TxpModel-method}: Return \code{txpWeights} slot

\item \code{txpTransFuncs,TxpModel-method}: Return \code{txpTransFuncs} slot

\item \code{names,TxpModel-method}: Return slice names; shortcut for
\code{names(txpSlices(x))}

\item \code{length,TxpModel-method}: Return number of slices in model; shortcut for
\code{length(txpSlices(x))}

\item \code{merge,TxpModel,TxpModel-method}: Merge two \code{TxpModel} objects into a single
model
}}

\section{Slots}{

\describe{
\item{\code{txpSlices}}{\link{TxpSliceList} object}

\item{\code{txpWeights}}{numeric vector specifying the relative weight of each slice;
when NULL, defaults to 1 (equal weighting) for each slice}

\item{\code{txpTransFuncs}}{\link{TxpTransFuncList} object (or list of functions
coercible to TxpTransFuncList)}
}}

\examples{
## Create TxpSliceList & TxpTransFuncList objects
s1 <- list(S1 = TxpSlice("inpt1"), S2 = TxpSlice("inpt2"))
tf <- list(NULL, sqrt = function(x) sqrt(x))

## Create TxpModel object
m1 <- TxpModel(txpSlices = s1, txpWeights = 2:1, txpTransFuncs = tf)
m1

## Access TxpModel slots
txpSlices(m1)
txpWeights(m1)
txpWeights(m1, adjusted = TRUE)
txpTransFuncs(m1)

## length
length(m1) ## equal to length(txpSlices(m1))
length(m1) == length(txpSlices(m1))

## names
names(m1) ## equal to names(txpSlices(m1))
all(names(m1) == names(txpSlices(m1)))

## Replacement
m2 <- m1
txpSlices(m2) <- list(S3 = TxpSlice("inpt3"), S4 = TxpSlice("inpt4"))
m2
names(m2)[2] <- "hello"
names(m2)
txpTransFuncs(m2) <- NULL
m2
txpTransFuncs(m2)[[1]] <- function(x) x^2
names(txpTransFuncs(m2))[1] <- "sq"
m2

## merge
m3 <- merge(m1, m2)
m3
}
