% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmbd.R
\name{icd9Clean}
\alias{icd9Clean}
\title{Reformat Comorbidity Measures}
\usage{
icd9Clean(input, style = c("touch", "hcup"))
}
\arguments{
\item{input}{a character matrix of ICD9 codes, with rows representing
patients.}

\item{style}{a character vector of length one indicating the reformatting
style to follow.  The possible option are "touch" and "hcup". The former
does the cleaning for this package; The latter does the reformatting for
the SAS script provided by HCUP.}
}
\value{
a matrix of cleaned ICD9 codes.
}
\description{
This function processes the character matrix of ICD9 codes by converting
them to character codes of length 5.  For SAS procedure from HCUP, it trims
all character string to be of length 5, adds the missing trailing
white space, and capitalizes the first character in ICD9 codes.
}
\examples{
data(dxDat)
icd <- dxDat[, -1L]
output <- icd9Clean(icd)
}
\author{
Jun Yan and Wenjie Wang
}
