% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_fips_and_names.R
\name{convert_fips_to_names}
\alias{convert_fips_to_names}
\title{convert fips codes to names of a geographies}
\usage{
convert_fips_to_names(
  FIPs,
  states = NULL,
  geo_header = "STATE",
  in_states = NULL
)
}
\arguments{
\item{FIPs}{string vector of fips code such as c("021", "002")}

\item{states}{string vector of state abbreviations having same length as FIPs}

\item{geo_header}{string, taking values of "STATE", "COUNTY", "PLACE", "COUSUB"
or "CBSA".}

\item{in_states}{which states are these FIPs generated from. Use state abbrevations
or "US" for national. Vector of unique states.}
}
\value{
vector of names corresponding to FIPs and states
}
\description{
convert fips codes to names of a geographies
}
\examples{
aaa <- convert_fips_to_names(c("11", "44"))
# [1] "DC" "RI"

bbb <- convert_fips_to_names(c("001", "013"), states = c("RI", "MA"), geo_header = "COUNTY")
# [1] "Bristol County" "Hampden County"


}
