% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{data_dir}
\alias{data_dir}
\title{Get Normalized Data Directory Path of a Program}
\usage{
data_dir(
  app_name,
  cl_arg = commandArgs()[grep("--data-dir", commandArgs()) + 1],
  env_var = Sys.getenv(toupper(paste0(app_name, "_DATA_DIR"))),
  create = FALSE,
  sep = "/"
)
}
\arguments{
\item{app_name}{Name of the program/package/app}

\item{cl_arg}{Value of app specific commandline parameter}

\item{env_var}{Value of app specific environment variable}

\item{create}{whether to create returned path, if it doesn't exists yet}

\item{sep}{Path separator to be used on Windows}
}
\value{
Normalized path to the data directory of \verb{$app_name}.
}
\description{
\code{data_dir} returns the absolute, normalized path to the
data directory of a program/package/app based on an optional app-specific
commandline argument, an optional app-specific environment variable and the
\href{https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html}{XDG Base Directory Specification}
}
\details{
The following algorithm is used to determine the location of the
data directory for application \verb{$app_name}:
\enumerate{
\item If parameter \verb{$cl_arg} is a non-empty string, return \code{cl_arg}
\item Else, if parameter \verb{$env_var} is a non-empty string, return \verb{$env_var}
\item Else, if environment variable (EV) \verb{$XDG_DATA_HOME} exists, return
\verb{$XDG_DATA_HOME/$app_name}
\item Else, if EV \verb{$HOME} exists, return \verb{$HOME/.local/share/$app_name}
\item Else, if EV \verb{$USERPROFILE} exists, return
\verb{$USERPROFILE/.local/share/$app_name}
\item Else, return \verb{$WD/.local/share}
}
}
\examples{
data_dir("myApp")
}
\seealso{
\code{\link[=config_dir]{config_dir()}}, \code{\link[=xdg_data_home]{xdg_data_home()}}
}
\keyword{path}
