% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precisionrecall.R
\name{precision}
\alias{precision}
\alias{vprecision}
\alias{recall}
\alias{vrecall}
\title{Precision and Recall}
\usage{
precision(w, p, subset)

vprecision(w, p, subset, n)

recall(w, p, subset)

vrecall(w, p, subset, n)
}
\arguments{
\item{w}{Numeric vector: Each entry represents one intersection.
Proportion of texts in this intersection.}

\item{p}{Numeric vector: Each entry represents one intersection.
Proportion of relevant texts in this intersection.}

\item{subset}{Logical vector: Each entry represents one intersection.
Controls if the intersection belongs to the subcorpus of interest or not.}

\item{n}{Integer vector: Number of Texts labeled in the corresponding intersection.}
}
\value{
Estimator for precision, recall, and their variances respectively.
}
\description{
Estimates Precision and Recall for sampling in different intersections
}
\examples{
w <- c(0.5, 0.1, 0.2, 0.2)
p <- c(0.01, 0.8, 0.75, 0.95)
subset <- c(FALSE, TRUE, FALSE, TRUE)
n <- c(40, 20, 15, 33)
precision(w, p, subset)
vprecision(w, p, subset, n)
recall(w, p, subset)
vrecall(w, p, subset, n)

}
