% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_diag_embed}
\alias{torch_diag_embed}
\title{Diag_embed}
\usage{
torch_diag_embed(self, offset = 0L, dim1 = -2L, dim2 = -1L)
}
\arguments{
\item{self}{(Tensor) the input tensor. Must be at least 1-dimensional.}

\item{offset}{(int, optional) which diagonal to consider. Default: 0        (main diagonal).}

\item{dim1}{(int, optional) first dimension with respect to which to        take diagonal. Default: -2.}

\item{dim2}{(int, optional) second dimension with respect to which to        take diagonal. Default: -1.}
}
\description{
Diag_embed
}
\section{diag_embed(input, offset=0, dim1=-2, dim2=-1) -> Tensor }{


Creates a tensor whose diagonals of certain 2D planes (specified by
\code{dim1} and \code{dim2}) are filled by \code{input}.
To facilitate creating batched diagonal matrices, the 2D planes formed by
the last two dimensions of the returned tensor are chosen by default.

The argument \code{offset} controls which diagonal to consider:
\itemize{
\item If \code{offset} = 0, it is the main diagonal.
\item If \code{offset} > 0, it is above the main diagonal.
\item If \code{offset} < 0, it is below the main diagonal.
}

The size of the new matrix will be calculated to make the specified diagonal
of the size of the last input dimension.
Note that for \code{offset} other than \eqn{0}, the order of \code{dim1}
and \code{dim2} matters. Exchanging them is equivalent to changing the
sign of \code{offset}.

Applying \code{torch_diagonal} to the output of this function with
the same arguments yields a matrix identical to input. However,
\code{torch_diagonal} has different default dimensions, so those
need to be explicitly specified.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(2, 3))
torch_diag_embed(a)
torch_diag_embed(a, offset=1, dim1=1, dim2=3)
}
}
