% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_tensordot}
\alias{torch_tensordot}
\title{Tensordot}
\usage{
torch_tensordot(a, b, dims = 2)
}
\arguments{
\item{a}{(Tensor) Left tensor to contract}

\item{b}{(Tensor) Right tensor to contract}

\item{dims}{(int or tuple of two lists of integers) number of dimensions to     contract or explicit lists of dimensions for \code{a} and     \code{b} respectively}
}
\description{
Returns a contraction of a and b over multiple dimensions.
\code{tensordot} implements a generalized matrix product.
}
\examples{
if (torch_is_installed()) {

a = torch_arange(start = 0, end = 60.)$reshape(c(3, 4, 5))
b = torch_arange(start = 0, end = 24.)$reshape(c(4, 3, 2))
torch_tensordot(a, b, dims = list(c(2, 1), c(1, 2)))
\dontrun{
a = torch_randn(3, 4, 5, device='cuda')
b = torch_randn(4, 5, 6, device='cuda')
c = torch_tensordot(a, b, dims=2)$cpu()
}
}
}
