% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-distance.R
\name{nnf_pdist}
\alias{nnf_pdist}
\title{Pdist}
\usage{
nnf_pdist(input, p = 2)
}
\arguments{
\item{input}{input tensor of shape \eqn{N \times M}.}

\item{p}{p value for the p-norm distance to calculate between each vector pair
\eqn{\in [0, \infty]}.}
}
\description{
Computes the p-norm distance between every pair of row vectors in the input.
This is identical to the upper triangular portion, excluding the diagonal, of
\verb{torch_norm(input[:, None] - input, dim=2, p=p)}. This function will be faster
if the rows are contiguous.
}
\details{
If input has shape \eqn{N \times M} then the output will have shape
\eqn{\frac{1}{2} N (N - 1)}.
}
