% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-columns.R
\name{grid_col_button}
\alias{grid_col_button}
\title{Display buttons in grid's column}
\usage{
grid_col_button(
  grid,
  column,
  inputId,
  label = NULL,
  icon = NULL,
  status = "default",
  btn_width = "100\%",
  ...
)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{column}{The name of the column where to create buttons.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Label to display on button, if \code{NULL} use column's content.}

\item{icon}{Icon to display in button.}

\item{status}{Bootstrap status (color) of the button: default, primary, success, info, warning, danger, ...
A class prefixed by \verb{btn-} will be added to the button.}

\item{btn_width}{Button's width.}

\item{...}{Further arguments passed to \code{\link[=grid_columns]{grid_columns()}}.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Display buttons in grid's column
}
\examples{
library(toastui)
library(shiny)

ui <- fluidPage(
  tags$h2("Buttons in grid"),
  datagridOutput("grid"),
  verbatimTextOutput("clicks")
)

server <- function(input, output, session) {

  dat <- data.frame(
    variable = paste(1:26, LETTERS, sep = " - "),
    button1 = 1:26,
    button2 = letters,
    button3 = LETTERS
  )

  output$grid <- renderDatagrid({
    datagrid(dat) \%>\%
      grid_col_button(
        column = "button1",
        inputId = "button1"
      ) \%>\%
      grid_col_button(
        column = "button2",
        inputId = "button2",
        align = "center",
        btn_width = "50\%",
        status = "primary"
      ) \%>\%
      grid_col_button(
        column = "button3",
        inputId = "button3",
        label = "Remove",
        icon = icon("trash"),
        status = "danger"
      )
  })

  output$clicks <- renderPrint({
    cat(
      "Button 1: ", input$button1,
      "\nButton 2: ", input$button2,
      "\nButton 3: ", input$button3,
      "\n"
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
