% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-props.R
\name{cal_props}
\alias{cal_props}
\title{Calendar properties}
\usage{
cal_props(cal, ...)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{...}{Either named arguments to use as calendar properties or a
\code{data.frame} with rows as calendars and columns as properties.
See \url{https://nhn.github.io/tui.calendar/latest/CalendarProps/} for options.}
}
\value{
A \code{calendar} htmlwidget.
}
\description{
Define calendar properties for grouping schedules under common theme.
}
\examples{
library(toastui)

# Define theme for schedules
calendar(cal_demo_data()) \%>\%
  cal_props(
    list(
      id = 1,
      name = "PERSO",
      color = "white",
      bgColor = "steelblue",
      borderColor = "steelblue"
    ),
    list(
      id = 2,
      name = "WORK",
      color = "white",
      bgColor = "forestgreen",
      borderColor = "forestgreen"
    )
  )


}
