% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_title}
\alias{tm_title}
\alias{tm_title_in}
\alias{tm_title_out}
\title{Map component: title}
\usage{
tm_title(
  text,
  size,
  color,
  padding,
  fontface,
  fontfamily,
  alpha,
  stack,
  just,
  frame,
  frame.color,
  frame.alpha,
  frame.lwd,
  frame.r,
  bg,
  bg.color,
  bg.alpha,
  position,
  group_id,
  width,
  height,
  z
)

tm_title_in(text, ..., position = tm_pos_in("left", "top"))

tm_title_out(text, ..., position = tm_pos_out("center", "top"))
}
\arguments{
\item{text}{text}

\item{size}{font size}

\item{color}{font color}

\item{padding}{padding}

\item{fontface}{font face, bold, italic}

\item{fontfamily}{font family}

\item{alpha}{alpha transparency of the text}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{just}{just}

\item{frame}{frame should a frame be drawn?}

\item{frame.color}{frame color}

\item{frame.alpha}{frame alpha transparancy}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{bg}{Show background?}

\item{bg.color}{Background color}

\item{bg.alpha}{Background transparency}

\item{position}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_comp_group]{tm_comp_group()}}.}

\item{group_id}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_comp_group]{tm_comp_group()}} where its argument \code{id} should correspond to \code{group_id}.}

\item{width, height}{width and height of the component.}

\item{z}{z index, e.g. the place of the component relative to the other componets}

\item{...}{passed on to \code{tm_title()}}
}
\description{
Map component that adds a title
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_components}{Vignette about components}
}
