% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_logo}
\alias{tm_logo}
\title{Map component: logo}
\usage{
tm_logo(
  file,
  height,
  margins,
  between_margin,
  stack,
  position,
  group_id,
  frame,
  frame.color,
  frame.alpha,
  frame.lwd,
  frame.r,
  z
)
}
\arguments{
\item{file}{either a filename or url of a png image. If multiple files/urls are provided with a character vector, the logos are placed near each other.
To specify logos for small multiples use a list of character values/vectors. In order to stack logos vertically, multiple \code{tm_logo} elements can be stacked.}

\item{height}{height of the logo in number of text line heights. The width is scaled based the height and the aspect ratio of the logo.
If multiple logos are specified by a vector or list, the heights can be specified accordingly.}

\item{margins}{margins}

\item{between_margin}{Margin between}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{position}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_comp_group]{tm_comp_group()}}.}

\item{group_id}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_comp_group]{tm_comp_group()}} where its argument \code{id} should correspond to \code{group_id}.}

\item{frame}{frame should a frame be drawn?}

\item{frame.color}{frame color}

\item{frame.alpha}{frame alpha transparancy}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{z}{z index, e.g. the place of the component relative to the other componets}
}
\description{
Map component that adds a logo.
}
\examples{
data(World)

tm_shape(World) +
	tm_polygons("HPI", fill.scale = tm_scale_intervals(values = "brewer.rd_yl_gn")) +
	tm_logo(c("https://www.r-project.org/logo/Rlogo.png",
			  system.file("help", "figures", "logo.png", package = "tmap"))) +
	tm_logo("http://blog.kulikulifoods.com/wp-content/uploads/2014/10/logo.png",
			height=5, position = c("left", "top"))
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_components}{Vignette about components}
}
