% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_mode.R
\name{tmap_mode}
\alias{tmap_mode}
\alias{ttm}
\title{Set tmap mode to static plotting or interactive viewing}
\usage{
tmap_mode(mode = c("plot", "view"))

ttm()
}
\arguments{
\item{mode}{one of
\describe{
       \item{\code{"plot"}}{Thematic maps are shown in the graphics device. This is the default mode, and supports all tmap's features, such as small multiples (see \code{\link{tm_facets}}) and extensive layout settings (see \code{\link{tm_layout}}). It is recommended for saving static maps (see \code{\link{save_tmap}}).} 
       \item{\code{"view"}}{Thematic maps are viewed interactively in the web browser or RStudio's Viewer pane. Maps are fully interactive with tiles from OpenStreetMap or other map providers. See \code{\link{tm_view}} for options related to the \code{"view"} mode. This mode generates a \code{\link[leaflet:leaflet]{leaflet}} widget, which can also be directly obtained with \code{\link{tmap_leaflet}}. With RMarkdown, it is possible to publish it to an HTML page. 
       There are a couple of contraints in comparison to \code{"plot"}:
       \itemize{
       \item The map is always projected accoring to the Web Mercator projection. Although this projection is the de facto standard for interactive web-based mapping, it lacks the equal-area property, which is important for many thematic maps, especially choropleths (see examples from \code{\link{tm_shape}}).
       \item Small multiples are not supported
       \item The legend cannot be made for aesthetics regarding size, which are bubble size and line width.
       \item Text labels are not supported (yet)
       \item The layout options set with \code{\link{tm_layout}}) regarding map format are not used. However, the styling options still apply.}
       }}}
}
\value{
the mode before changing
}
\description{
Set tmap mode to static plotting or interactive viewing. The global option \code{tmap.mode} determines the whether thematic maps are plot in the graphics device, or shown as an interactive leaflet map. The function \code{tmap_mode} is a wrapper to set this global option. The convenient function \code{ttm} is a toggle switch between the two modes. Tip: use \code{tmap_mode} in scripts and \code{ttm} in the console.
}
\examples{
# world choropleth/bubble map of the world
data(World, metro)
metro$growth <- (metro$pop2020 - metro$pop2010) / (metro$pop2010 * 10) * 100

map1 <- tm_shape(World) +
	tm_polygons("income_grp", palette="-Blues", contrast=.7, id="name", title="Income group") +
	tm_shape(metro) +
	tm_bubbles("pop2010", col = "growth", 
		border.col = "black", border.alpha = .5, 
		style="fixed", breaks=c(-Inf, seq(0, 6, by=2), Inf),
		palette="-RdYlBu", contrast=1, 
		title.size="Metro population", 
		title.col="Growth rate (\%)", id="name") + 
	tm_layout(legend.bg.color = "grey90", legend.bg.alpha=.5, legend.frame=TRUE)

# initial mode: "plot"
current.mode <- tmap_mode("plot")

# plot map
map1

# switch to other mode: "view"
ttm()

# view map
map1

# choropleth of the Dutch population in interactive mode:
data(NLD_muni, NLD_prov)
NLD_muni$pop_dens <- calc_densities(NLD_muni, var = "population")

tm_shape(NLD_muni) +
	tm_fill(col="pop_dens", 
		style="kmeans", 
		title = "Population (per km^2)", id = "name") +
	tm_borders("grey25", alpha=.5) + 
	tm_shape(NLD_prov) +
	tm_borders("grey40", lwd=2)

# restore current mode
tmap_mode(current.mode)
}
\seealso{
\href{../doc/tmap-modes.html}{\code{vignette("tmap-modes")}}, \code{\link{tm_view}} for viewing options, and \code{\link{tmap_leaflet}} for obtaining a leaflet widget
}

