% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_bubbles}
\alias{tm_bubbles}
\title{Draw bubbles}
\usage{
tm_bubbles(size = 1, col = "blueviolet", alpha = NA, border.col = NA,
  border.lwd = 1, border.alpha = NA, scale = 1, size.lim = NA,
  sizes.legend = NULL, sizes.legend.labels = NULL, n = 5,
  style = "pretty", breaks = NULL, palette = NULL, labels = NULL,
  auto.palette.mapping = TRUE, contrast = 1, max.categories = 12,
  colorNA = "#FF1414", textNA = "Missing", xmod = 0, ymod = 0)
}
\arguments{
\item{size}{\code{shp} data variable that determines the bubble sizes. Multiple variable names create small multiples}

\item{col}{color(s) of the bubble. Either a color (vector), or categorical variable name(s). Multiple variable names create small multiples}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{border.col}{color of the bubble borders.}

\item{border.lwd}{line width of the bubble borders. If \code{NA} (default), no bubble borders are drawn.}

\item{border.alpha}{transparency number, regarding the bubble borders, between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{scale}{bubble size multiplier number.}

\item{size.lim}{vector of two limit values of the \code{size} variable. Only bubbles are drawn whose value is greater than or equal to the first value. Bubbles whose values exceed the second value are drawn at the size of the second value. Only applicable when \code{size} is the name of a numeric variable of \code{shp}}

\item{sizes.legend}{vector of bubble sizes that are shown in the legend. By default, this is determined automatically.}

\item{sizes.legend.labels}{vector of labels for that correspond to \code{sizes.legend}.}

\item{n}{preferred number of color scale classes. Only applicable when \code{col} is a numeric variable name.}

\item{style}{method to cut the color scale: e.g. "fixed", "equal", "pretty", "quantile", or "kmeans". See the details in \code{\link[classInt:classIntervals]{classIntervals}}. Only applicable when \code{col} is a numeric variable name.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{palette}{color palette (see \code{RColorBrewer::display.brewer.all}) for the bubbles. Only when \code{col} is set to a variable.}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values.}

\item{contrast}{number between 0 and 1 (default) that determines the contrast of the palette. Only applicable when \code{auto.palette.mapping=TRUE} and \code{col} is a numeric variable name.}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{colour for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}

\item{xmod}{horizontal position modification of the bubbles, relatively where 0 means no modification, and 1 means the total width of the frame. Either a single number for all polygons, or a numeric variable in the shape data specifying a number for each polygon. Together with \code{ymod}, it determines position modification of the bubbles. In most coordinate systems (projections), the origin is located at the bottom left, so negative \code{xmod} move the bubbles to the left, and negative \code{ymod} values to the bottom.}

\item{ymod}{vertical position modification. See xmod.}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draws bubbles. Both colors and sizes of the bubbles can be mapped to data variables.
}
\examples{
data(World)
data(Europe)
data(cities)

tm_shape(World) +
    tm_fill() +
tm_shape(cities) +
    tm_bubbles("pop_max", scale=.5) +
tm_layout_World("Cities of the World")

tm_shape(Europe) +
    tm_borders() +
    tm_fill() +
tm_shape(cities) +
    tm_bubbles(size="pop_max", col="capital", size.lim=c(0, 2e7)) +
	tm_text("name", cex="pop_max", scale=2, root=3, ymod=-.015, bg.alpha=0) +
tm_layout_Europe("Metropolitan population", legend.titles=c(bubble.col="Capital"))

}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

