% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/approx_areas.R
\name{approx_areas}
\alias{approx_areas}
\title{Approximate area sizes of the shapes}
\usage{
approx_areas(shp, total.area.km2 = NA, units = NULL)
}
\arguments{
\item{shp}{shape object, i.e. a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}

\item{total.area.km2}{total area size of \code{shp} in number of squared kilometers. If \code{NA}, and \code{unit="km2"}, then the polygon coordinates are assumed to be in meters.}

\item{units}{one of
\describe{
    \item{\code{"km2"}:}{Squared kilometers. For this method, \code{total.area.km2} is required. In this case, the area sizes are also returned in squared kilometers.}
    \item{\code{"abs"}:}{Absolute numbers based on polygon coordinates. Only usefull if the projection satisfies the equal-area property. Note: these are equal to the \code{area} slots of the polygons, where the \code{area} slots of the holes are subtracted. Also note that for many projections, the coordinate units are meters, so the area sizes correspond to squared meters (rather than squared kilometers).}
    \item{\code{"prop"}:}{Proportional numbers. In other words, the total of the area sizes equals one.}
    \item{\code{"norm"}:}{Normalized numbers. All area sizes are normalized to the largest area, of which the area size equals one.}}
    The default method is \code{"abs"}, unless \code{total.area.km2} is specified (in that case, it is \code{"km2"}).}
}
\value{
Numeric vector of area sizes.
}
\description{
Approximate the area sizes of the polygons either in 1) squared kilometers, 2) absolute numbers based on the polygon coordinates, 3) proportional numbers, 4) normalized numbers.
}
\details{
To approximate the sizes in squared kilometer, \code{total.area.km2} is required. Note that this method is an approximation, since it depends on the used projection and the level of detail of the SpatialPolygons object. Projections with equal-area property are highly recommended.
}
\examples{
data(World)

data(NLD_muni)

NLD_muni$area <- approx_areas(NLD_muni, total.area.km2 = 33893)

tm_shape(NLD_muni) +
	tm_bubbles(size="area") +
	tm_layout("Area in km2")
}

