% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip_or}
\alias{tip_or}
\alias{tip_or_with_continuous}
\title{Tip an observed odds ratio with a normally distributed confounder.}
\usage{
tip_or(
  effect,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  or_correction = FALSE
)

tip_or_with_continuous(
  effect,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  or_correction = FALSE
)
}
\arguments{
\item{effect}{Numeric positive value. Observed exposure - outcome odds ratio.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{smd}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{or_correction}{Logical. Indicates whether to use a correction factor.
The methods used for this function are based on relative risks. For rare
outcomes, an odds ratio approximates a relative risk. For common outcomes,
a correction factor is needed. If you have a common outcome (>15\%),
set this to \code{TRUE}. Default: \code{FALSE}.}
}
\value{
Data frame.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{smd}
\item \code{outcome_association}
}
}
\examples{
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip_or(1.2, smd = -2)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip_or(1.2, smd = -2, outcome_association = .99)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  glm(am ~ mpg, data = mtcars, family = "binomial") \%>\%
   broom::tidy(conf.int = TRUE, exponentiate = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   dplyr::pull(conf.low) \%>\%
   tip_or(outcome_association = 2.5, or_correction = TRUE)
}
}
