% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_coef_with_binary}
\alias{adjust_coef_with_binary}
\title{Adjust an observed coefficient from a loglinear model with a binary confounder}
\usage{
adjust_coef_with_binary(
  effect,
  exposed_p,
  unexposed_p,
  outcome_association,
  verbose = TRUE
)
}
\arguments{
\item{effect}{Numeric. Observed exposure - outcome effect from a loglinear
model. This can be the beta coefficient, the lower confidence bound of
the beta coefficient, or the upper confidence bound of the beta
coefficient.}

\item{exposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{outcome_association}{Numeric. Estimated association
between the unmeasured confounder and the outcome.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\value{
Data frame.
}
\description{
Adjust an observed coefficient from a loglinear model with a binary confounder
}
\examples{
adjust_coef_with_binary(1.1, 0.5, 0.3, 1.3)
}
