% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_rr}
\alias{adjust_rr}
\title{Adjust an observed relative risk for a normally distributed
confounder}
\usage{
adjust_rr(effect, smd, outcome_association, verbose = TRUE)
}
\arguments{
\item{effect}{Numeric positive value. Observed exposure - outcome relative risk.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{smd}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric. Estimated association
between the unmeasured confounder and the outcome.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\value{
Data frame.
}
\description{
Adjust an observed relative risk for a normally distributed
confounder
}
\examples{
adjust_rr(1.2, 0.5, 1.1)
}
