% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{latexmk}
\alias{latexmk}
\alias{pdflatex}
\alias{xelatex}
\alias{lualatex}
\title{Compile a LaTeX document to PDF}
\usage{
latexmk(file, engine = c("pdflatex", "xelatex", "lualatex"), bib_engine = c("bibtex", 
    "biber"), emulation = TRUE, max_times = 10, install_packages = emulation && 
    tlmgr_available())

pdflatex(...)

xelatex(...)

lualatex(...)
}
\arguments{
\item{file}{A LaTeX file path.}

\item{engine}{A LaTeX engine.}

\item{bib_engine}{A bibliography engine.}

\item{emulation}{Whether to use \command{latexmk} emulation (by default,
\code{TRUE} if the command \command{latexmk} is not available). You can set
the global option \code{options(tinytex.latexmk.emulation = TRUE)} to
always use emulation.}

\item{max_times}{The maximum number of times to rerun the LaTeX engine when
using emulation. You can set the global option
\code{tinytex.compile.max_times}, e.g.,
\code{options(tinytex.compile.max_times = 3)}.}

\item{install_packages}{Whether to automatically install missing LaTeX
packages found by \code{\link{parse_packages}()} from the LaTeX log. This
argument is only for the emulation mode and TeX Live.}

\item{...}{Arguments to be passed to \code{latexmk()} (other than
\code{engine} and \code{emulation}).}
}
\description{
The function \code{latexmk()} uses the system command \command{latexmk} to
compile a LaTeX document to PDF; if \command{latexmk} is not available, use a
simple emulation. The functions \code{pdflatex()}, \code{xelatex()}, and
\code{lualatex()} are wrappers of \code{latexmk(engine =, emulation = TRUE)}.
}
\details{
The \command{latexmk} emulation works like this: run the LaTeX engine once
(e.g., \command{pdflatex}), run \command{makeindex} to make the index if
necessary (the \file{*.idx} file exists), run the bibliography engine
\command{bibtex} or \command{biber} to make the bibliography if necessary
(the \file{*.aux} or \file{*.bcf} file exists), and finally run the LaTeX
engine a number of times (the maximum is 10 by default) to resolve all
cross-references.
}
